/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.config;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.CombinableMatcher;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.generator.FactoryMethod;
import org.hamcrest.generator.FactoryWriter;
import org.hamcrest.generator.SugarConfiguration;
import org.hamcrest.generator.config.XmlConfigurator;
import org.xml.sax.InputSource;

public class XmlConfiguratorTest
extends TestCase {
    private MockSugarConfiguration sugarConfiguration;
    private XmlConfigurator config;

    protected void setUp() throws Exception {
        super.setUp();
        this.sugarConfiguration = new MockSugarConfiguration();
        this.config = new XmlConfigurator((SugarConfiguration)this.sugarConfiguration, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public void testAddsMatcherFactoryMethodsToConfiguration() throws Exception {
        this.config.load(XmlConfiguratorTest.createXml("<matchers>  <factory class='org.hamcrest.generator.config.XmlConfiguratorTest$SomeMatcher'/>  <factory class='org.hamcrest.generator.config.XmlConfiguratorTest$AnotherMatcher'/></matchers>"));
        MatcherAssert.assertThat(this.sugarConfiguration.factoryMethods(), (Matcher)IsCollectionContaining.hasItem((Object)new FactoryMethod(SomeMatcher.class.getName().replace('$', '.'), "matcher1", "org.hamcrest.Matcher")));
        MatcherAssert.assertThat(this.sugarConfiguration.factoryMethods(), (Matcher)IsCollectionContaining.hasItem((Object)new FactoryMethod(SomeMatcher.class.getName().replace('$', '.'), "matcher2", "org.hamcrest.Matcher")));
        MatcherAssert.assertThat(this.sugarConfiguration.factoryMethods(), (Matcher)IsCollectionContaining.hasItem((Object)new FactoryMethod(AnotherMatcher.class.getName().replace('$', '.'), "matcher3", "org.hamcrest.CombinableMatcher")));
    }

    private static InputSource createXml(String xml) {
        return new InputSource(new StringReader(xml));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockSugarConfiguration
    implements SugarConfiguration {
        private final List<FactoryMethod> seenFactoryMethods = new ArrayList<FactoryMethod>();
        private final List<FactoryWriter> seenFactoryWriters = new ArrayList<FactoryWriter>();

        private MockSugarConfiguration() {
        }

        public void addWriter(FactoryWriter factoryWriter) {
            this.seenFactoryWriters.add(factoryWriter);
        }

        public void addFactoryMethod(FactoryMethod method) {
            this.seenFactoryMethods.add(method);
        }

        public void addFactoryMethods(Iterable<FactoryMethod> methods) {
            for (FactoryMethod method : methods) {
                this.addFactoryMethod(method);
            }
        }

        public List<FactoryMethod> factoryMethods() {
            return this.seenFactoryMethods;
        }
    }

    public static class AnotherMatcher {
        @Factory
        public static CombinableMatcher matcher3() {
            return null;
        }
    }

    public static class SomeMatcher {
        @Factory
        public static Matcher matcher1() {
            return null;
        }

        @Factory
        public static Matcher matcher2() {
            return null;
        }
    }
}

